local assets=
{
	Asset("ANIM", "anim/mgammo.zip"),
	Asset("ATLAS", "images/inventoryimages/mgammo.xml"),
    Asset("IMAGE", "images/inventoryimages/mgammo.tex"),
}

local prefabs =
{

}

local function OnHit(inst, owner, target)
    inst:Remove()    
end


local function fncommon(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

	inst.AnimState:SetBank("mgammo")
    inst.AnimState:SetBuild("mgammo")
    inst.AnimState:PlayAnimation("idle", false)
    		
    inst:AddTag("projectile")
				
    inst:AddComponent("stackable")	 
	inst.components.stackable.maxsize = 40
	
	inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(100)
	inst.components.projectile:SetOnHitFn(OnHit)
    inst.components.projectile:SetOnMissFn(OnHit)
	
    inst:AddComponent("inspectable")
    	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/mgammo.xml"

	return inst
end



STRINGS.NAMES.MGAMMO = "Machine gun ammo."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MGAMMO = "Ammo for the pkm."


return Prefab( "common/inventory/mgammo", fncommon, assets)
